<style>
    .headlap {
        text-align: center;
    }

    .headlap h3 {
        font-weight: 900;
    }

    .headlap h5 {
        font-weight: 800;
        color: red;
    }

    table.lap {
        width: 100%;
        border: 1px solid;
    }

    .lap tr th {
        border: 1px solid;
        border-color: rgb(126, 124, 124);
        text-align: center;
        background-color: rgb(22, 128, 226);
        color: white;
    }

    .lap tr td {
        border: 1px solid;
        border-color: rgb(126, 124, 124);
        font-size: 15px;
        text-align: left;
        padding: 3px;
    }

    @media print {

        @page {
            margin: 20px;
            size: auto;
        }

        .lap tr th {
            border: 1px solid;
            border-color: rgb(126, 124, 124);
            text-align: center;
            background-color: rgb(115, 115, 245);
            color: white;
            font-size: 10pt;
        }

        .lap tr td {
            border: 1px solid;
            border-color: rgb(126, 124, 124);
            font-size: 12px;
        }
    }
</style>
<div class="headlap">
    <h3>LAPORAN DATA PENGELUARAN <br>
        {{ $data['tgl1'] }} - {{ $data['tgl2'] }}
    </h3>
    <div style="border:1px solid; margin: 10px"></div>
    <table class="lap">
        <thead>
            <tr>
                <th>No</th>
                <th>No. Pengeluaran</th>
                <th>Supplier</th>
                <th>Tanggal</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            @php
                $ttl = [];
            @endphp
            @forelse ($pengeluaran as $p)
                @php
                    $ttl[] = $p->total;
                @endphp
                <tr>
                    <td class="text-center">{{ $no++ }}</td>
                    <td>{{ $p->kd_pengeluaran }}</td>
                    <td>{{ $p->supplier->nm_supplier }}</td>
                    <td>{{ tgl_time($p->created_at) }}</td>
                    <td class="text-right">{{ number_format($p->total, 0, ',', '.') }},-</td>
                </tr>
            @empty
                <tr>
                    <td colspan="5" class="text-center">Data tidak ditemukan</td>
                </tr>
            @endforelse

        @empty(!array_sum($ttl))
            <tr style="background-color: rgb(241, 210, 210)">

                <td class="text-center" style="font-size:17px; font-weight: bold" colspan="4">Jumlah Total</td>
                <td class="text-right" style="font-size:17px; font-weight: bold">
                    {{ number_format(array_sum($ttl), 0, ',', '.') }},-
                </td>
            </tr>
        @endempty

    </tbody>
</table>

</div>
